<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\ExtInventory\Block\Adminhtml\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Html\Select;

/**
 * Renderer for Event Configuration
 */
class MatrixSource extends AbstractFieldArray
{

    /**
     * @var AllSourcesFactory
     */
    protected $allSourcesFactory;

    /**
     * @param AllSourcesFactory $allSourcesFactory
     * @param Context $context
     * @param array $data
     */
    public function __construct(
        AllSourcesFactory $allSourcesFactory,
        Context           $context,
        array             $data = []
    )
    {
        $this->allSourcesFactory = $allSourcesFactory;
        parent::__construct($context, $data);
    }

    /**
     * Prepare to render
     *
     * @return void
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $sources = $this->allSourcesFactory->create()->toOptionArray();

        $initialSourcesBlock = $this->getLayout()->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'initial_source'))
            ->setName($this->_getCellInputElementName('initial_source'))
            ->setClass('select')
            ->setOptions($sources);

        $finalSourcesBlock = $this->getLayout()->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'final_source'))
            ->setName($this->_getCellInputElementName('final_source'))
            ->setClass('select')
            ->setOptions($sources);

        $this->addColumn('initial_source', [
            'label'    => __('Initial Source'),
            'renderer' => $initialSourcesBlock
        ]);

        $this->addColumn('final_source', [
            'label'    => __('Final Source'),
            'renderer' => $finalSourcesBlock
        ]);

        $this->_addButtonLabel = __('Add Source Mapping');
    }

}

