<?php

namespace FiloBlu\ExtInventory\Block\Adminhtml\Orderedit\Tab\Multistock;

use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Registry;

/**
 *
 */
class View extends Template implements TabInterface
{
    /**
     * @var string
     */
    protected $_template = 'tab/view/multistock.phtml';

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        array $data = []
    ) {
        $this->_coreRegistry = $registry;
        parent::__construct($context, $data);
    }

    public function getOrderId()
    {
        return $this->getOrder()->getEntityId();
    }

    public function getOrder()
    {
        return $this->_coreRegistry->registry('current_order');
    }

    /**
     * @return array|false
     */
    public function getAllWarehouseData()
    {
        $all_warehouse_data = [];
        $items = $this->getOrder()->getAllItems();
        foreach ($items as $item) {
            if ($item->getProductType() == 'simple') {
                if (!$item->getExtensionAttributes() || !$item->getExtensionAttributes()->getFiloBluOrderItem()) {
                    continue;
                }

                $filoblu_order_items = $item->getExtensionAttributes()->getFiloBluOrderItem();

                if (\count($filoblu_order_items) == 0) {
                    continue;
                }

                foreach ($filoblu_order_items as $filoblu_order_item) {
                    $all_warehouse_data[] = $filoblu_order_item->getData();
                }
            }
        }

        if (\count($all_warehouse_data) == 0) {
            return false;
        }
        return $all_warehouse_data;
    }

    /**
     * Return Tab label
     *
     * @return string
     */
    public function getTabLabel()
    {
        return __('Multistock');
    }

    /**
     * Return Tab title
     *
     * @return string
     */
    public function getTabTitle()
    {
        return __('Multistock');
    }

    /**
     * Can show tab in tabs
     *
     * @return boolean
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * Tab is hidden
     *
     * @return boolean
     */
    public function isHidden()
    {
        return false;
    }
}