<?php

namespace FiloBlu\ExtInventory\Plugin\InventoryConfigurationApi\GetStockItemConfiguration;

use Exception;
use Magento\Framework\App\ResourceConnection;
use Magento\InventoryConfigurationApi\Api\Data\StockItemConfigurationInterface;
use Magento\InventoryConfigurationApi\Api\GetStockItemConfigurationInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 * Class LoadIsInStockPlugin
 * @package FiloBlu\ExtInventory\Plugin\InventoryConfigurationApi\GetStockItemConfiguration
 */
class LoadIsInStockPlugin
{
    /**
     * @var ResourceConnection
     */
    protected $resourceConnection;

    const IS_ENABLE_PATH = 'msi/plugin/is_in_stock_enable';
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * LoadIsInStockPlugin constructor.
     * @param ResourceConnection $resourceConnection
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        ResourceConnection $resourceConnection,
        ScopeConfigInterface $scopeConfig)
    {
        $this->resourceConnection = $resourceConnection;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @param GetStockItemConfigurationInterface $subject
     * @param StockItemConfigurationInterface $result
     * @param string $sku
     * @param int $stockId
     * @return StockItemConfigurationInterface
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterExecute(
        GetStockItemConfigurationInterface $subject,
        StockItemConfigurationInterface $result,
        string $sku,
        int $stockId
    ): StockItemConfigurationInterface
    {
        try {
            if (!$this->scopeConfig->getValue(self::IS_ENABLE_PATH)) {
                return $result;
            }
            $inventoryStock = $this->resourceConnection->getTableName("inventory_stock_{$stockId}");
            $row = $this->resourceConnection->getConnection()->fetchRow(
                "SELECT `is_salable` FROM `{$inventoryStock}` WHERE `sku` = :sku",
                ['sku' => $sku]
            );

            if (!isset($row['is_salable']) || $row['is_salable'] === null) {
                return $result;
            }
            $extensionAttributes = $result->getExtensionAttributes();
            $extensionAttributes->setIsInStock($row['is_salable'] > 0);
            $result->setExtensionAttributes($extensionAttributes);
        } catch (Exception $e) {
            return $result;
        }
        return $result;
    }
}
