<?php

namespace FiloBlu\ExtInventory\Model;

use Exception;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterfaceFactory;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceSearchResultsInterfaceFactory;
use FiloBlu\ExtInventory\Api\InventoryFbOrderItemSourceRepositoryInterface;
use FiloBlu\ExtInventory\Model\ResourceModel\InventoryFbOrderItemSource as ResourceInventoryFbOrderitemSource;
use FiloBlu\ExtInventory\Model\ResourceModel\InventoryFbOrderItemSource\CollectionFactory as InventoryFbOrderitemSourceCollectionFactory;
use Magento\Framework\Api\DataObjectHelper;
use Magento\Framework\Api\ExtensibleDataObjectConverter;
use Magento\Framework\Api\ExtensionAttribute\JoinProcessorInterface;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Reflection\DataObjectProcessor;
use Magento\Sales\Api\Data\OrderItemInterface;

/**
 * Class InventoryFbOrderItemSourceRepository
 * @package FiloBlu\ExtInventory\Model
 */
class InventoryFbOrderItemSourceRepository implements InventoryFbOrderItemSourceRepositoryInterface
{

    /**
     * @var DataObjectHelper
     */
    protected $dataObjectHelper;
    /**
     * @var InventoryFbOrderItemSourceFactory
     */
    protected $inventoryFbOrderItemSourceFactory;
    /**
     * @var InventoryFbOrderItemSourceSearchResultsInterfaceFactory
     */
    protected $searchResultsFactory;
    /**
     * @var DataObjectProcessor
     */
    protected $dataObjectProcessor;
    /**
     * @var JoinProcessorInterface
     */
    protected $extensionAttributesJoinProcessor;
    /**
     * @var ExtensibleDataObjectConverter
     */
    protected $extensibleDataObjectConverter;
    /**
     * @var ResourceInventoryFbOrderitemSource
     */
    protected $resource;
    /**
     * @var InventoryFbOrderitemSourceCollectionFactory
     */
    protected $inventoryFbOrderItemSourceCollectionFactory;
    /**
     * @var InventoryFbOrderItemSourceInterfaceFactory
     */
    protected $dataInventoryFbOrderItemSourceFactory;
    /**
     * @var CollectionProcessorInterface
     */
    private $collectionProcessor;

    /**
     * @param ResourceInventoryFbOrderitemSource $resource
     * @param InventoryFbOrderItemSourceFactory $inventoryFbOrderItemSourceFactory
     * @param InventoryFbOrderItemSourceInterfaceFactory $dataInventoryFbOrderItemSourceFactory
     * @param InventoryFbOrderItemSourceCollectionFactory $inventoryFbOrderItemSourceCollectionFactory
     * @param InventoryFbOrderItemSourceSearchResultsInterfaceFactory $searchResultsFactory
     * @param DataObjectHelper $dataObjectHelper
     * @param DataObjectProcessor $dataObjectProcessor
     * @param CollectionProcessorInterface $collectionProcessor
     * @param JoinProcessorInterface $extensionAttributesJoinProcessor
     * @param ExtensibleDataObjectConverter $extensibleDataObjectConverter
     */
    public function __construct(
        ResourceInventoryFbOrderitemSource $resource,
        InventoryFbOrderItemSourceFactory $inventoryFbOrderItemSourceFactory,
        InventoryFbOrderItemSourceInterfaceFactory $dataInventoryFbOrderItemSourceFactory,
        InventoryFbOrderItemSourceCollectionFactory $inventoryFbOrderItemSourceCollectionFactory,
        InventoryFbOrderItemSourceSearchResultsInterfaceFactory $searchResultsFactory,
        DataObjectHelper $dataObjectHelper,
        DataObjectProcessor $dataObjectProcessor,
        CollectionProcessorInterface $collectionProcessor,
        JoinProcessorInterface $extensionAttributesJoinProcessor,
        ExtensibleDataObjectConverter $extensibleDataObjectConverter
    ) {
        $this->resource = $resource;
        $this->inventoryFbOrderItemSourceFactory = $inventoryFbOrderItemSourceFactory;
        $this->inventoryFbOrderItemSourceCollectionFactory = $inventoryFbOrderItemSourceCollectionFactory;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->dataObjectHelper = $dataObjectHelper;
        $this->dataInventoryFbOrderItemSourceFactory = $dataInventoryFbOrderItemSourceFactory;
        $this->dataObjectProcessor = $dataObjectProcessor;
        $this->collectionProcessor = $collectionProcessor;
        $this->extensionAttributesJoinProcessor = $extensionAttributesJoinProcessor;
        $this->extensibleDataObjectConverter = $extensibleDataObjectConverter;
    }

    /**
     * {@inheritdoc}
     */
    public function save(
        InventoryFbOrderItemSourceInterface $inventoryFbOrderItemSource
    ) {
        $data = $inventoryFbOrderItemSource->getData();
        $inventoryFbOrderItemSourceModel = $this->inventoryFbOrderItemSourceFactory->create();
        $inventoryFbOrderItemSourceModel->setData($data);

        try {
            $this->resource->save($inventoryFbOrderItemSourceModel);
        } catch (Exception $exception) {
            throw new CouldNotSaveException(__(
                'Could not save the inventoryFbOrderitemSource: %1',
                $exception->getMessage()
            ));
        }
        return $inventoryFbOrderItemSourceModel->getDataModel();
    }

    /**
     * {@inheritdoc}
     */
    public function getList(
        SearchCriteriaInterface $criteria
    ) {
        $collection = $this->inventoryFbOrderItemSourceCollectionFactory->create();

        $this->collectionProcessor->process($criteria, $collection);

        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);

        $items = [];
        foreach ($collection as $model) {
            $items[] = $model->getDataModel();
        }

        $searchResults->setItems($items);
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * {@inheritdoc}
     */
    public function deleteById($inventoryFbOrderItemSourceId)
    {
        return $this->delete($this->get($inventoryFbOrderItemSourceId));
    }

    /**
     * {@inheritdoc}
     */
    public function delete(
        InventoryFbOrderItemSourceInterface $inventoryFbOrderItemSource
    ) {
        try {
            $inventoryFbOrderItemSourceModel = $this->inventoryFbOrderItemSourceFactory->create();
            $this->resource->load($inventoryFbOrderItemSourceModel, $inventoryFbOrderItemSource->getInventoryFbOrderitemSourceId());
            $this->resource->delete($inventoryFbOrderItemSourceModel);
        } catch (Exception $exception) {
            throw new CouldNotDeleteException(__(
                'Could not delete the inventory_fb_orderitem_source: %1',
                $exception->getMessage()
            ));
        }
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function get($inventoryFbOrderItemSourceId)
    {
        $inventoryFbOrderItemSource = $this->inventoryFbOrderItemSourceFactory->create();
        $this->resource->load($inventoryFbOrderItemSource, $inventoryFbOrderItemSourceId);
        if (!$inventoryFbOrderItemSource->getId()) {
            throw new NoSuchEntityException(__('inventory_fb_orderitem_source with id "%1" does not exist.', $inventoryFbOrderItemSourceId));
        }
        return $inventoryFbOrderItemSource->getDataModel();
    }

    /**
     * @inheritDoc
     * @throws NoSuchEntityException
     */
    public function getByOrderItem(OrderItemInterface $orderItem)
    {
        $inventoryFbOrderItemSource = $this->inventoryFbOrderItemSourceFactory->create();
        $this->resource->load($inventoryFbOrderItemSource, $orderItem->getItemId(), InventoryFbOrderItemSourceInterface::ORDER_ITEM_ID);
        if (!$inventoryFbOrderItemSource->getId()) {
            throw new NoSuchEntityException(__('inventory_fb_orderitem_source with with order_item_id "%1" does not exist.', $orderItem->getItemId()));
        }
        return $inventoryFbOrderItemSource->getDataModel();
    }
}
