<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Data;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\InventorySourceSelectionApi\Api\GetSourceSelectionAlgorithmListInterface;

/**
 * Class InitialSourceSelectionAlgorithmOptionSource
 * @package FiloBlu\ExtInventory\Data
 */
class InitialSourceSelectionAlgorithmOptionSource implements OptionSourceInterface
{
    /**
     * @var array|null
     */
    protected $options = null;

    /**
     * @var GetSourceSelectionAlgorithmListInterface
     */
    private $algorithmList;

    /**
     * SourceSelectionAlgorithmOptionSource constructor.
     * @param GetSourceSelectionAlgorithmListInterface $algorithmList
     */
    public function __construct(GetSourceSelectionAlgorithmListInterface $algorithmList)
    {
        $this->algorithmList = $algorithmList;
    }

    /**
     * @return array|null
     */
    public function toOptionArray()
    {
        if ($this->options !== null) {
            return $this->options;
        }

        foreach ($this->algorithmList->execute() as $algorithm) {

            // TODO: Temporary workaround until we switch to new implementation
            if (in_array($algorithm->getCode(), ['filoblu_final_source', 'priority', 'distance'])) {
                continue;
            }

            $this->options[] = [
                'value' => $algorithm->getCode(),
                'label' => $algorithm->getTitle()
            ];
        }

        return $this->options;
    }
}
