<?php

namespace FiloBlu\ExtInventory\Cron;

use Exception;
use FiloBlu\ExtInventory\Model\ReservationCleaner;
use FiloBlu\ExtInventory\Model\ReservationStatus;
use Psr\Log\LoggerInterface;

/**
 * Class CleanUpReservationsCommand
 * @package FiloBlu\ExtInventory\Cron
 */
class CleanUpReservations
{
    /**
     * @var ReservationCleaner
     */
    private $reservationCleaner;
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * CleanUpReservationsCommand constructor.
     * @param LoggerInterface $logger
     * @param ReservationCleaner $reservationCleaner
     */
    public function __construct(
        LoggerInterface $logger,
        ReservationCleaner $reservationCleaner
    ) {
        $this->reservationCleaner = $reservationCleaner;
        $this->logger = $logger;
    }

    /**
     * @return int|void|null
     * @throws Exception
     */
    public function execute()
    {
        $collector = $this->reservationCleaner->cleanAll();

        foreach ($collector->getAll() as $statusCode => $statuses) {
            foreach ($statuses as $status) {
                switch ($statusCode) {
                    case ReservationStatus::STATUS_ERROR:
                        $this->logger->error("Broken reservations for order with id {$status->getOrderId()}");
                        break;

                    case ReservationStatus::STATUS_CLEANED:
                        $this->logger->info("Cleaned reservations for order with id {$status->getOrderId()}");
                        break;
                }
            }
        }
    }
}
