<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Block\Adminhtml\System\Config;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Inventory\Model\ResourceModel\Source\Collection;

/**
 *
 */
class AllSources implements OptionSourceInterface
{
    /** @var Collection */
    protected $sourcesCollection;

    /** @var array|null */
    private $options;

    /**
     * @param Collection $getSourcesCollection
     */
    public function __construct(
        Collection $getSourcesCollection
    )
    {
        $this->sourcesCollection = $getSourcesCollection;
    }


    /**
     * @return array
     */
    public function toOptionArray()
    {
        if ($this->options !== null) {
            return $this->options;
        }

        $this->options[] = ['label' => '--Please Select--', 'value' => ''];


        foreach ($this->sourcesCollection->getItems() as $source) {

            $this->options[] = [
                'value' => $source->getSourceCode(),
                'label' => $source->getName()
            ];
        }

        return $this->options;
    }
}
