<?php

namespace FiloBlu\ExtInventory\Model;

use Magento\Framework\App\ResourceConnection;
use Zend_Db;

/**
 * Class Reservation
 * @package FiloBlu\ExtInventory\Model
 */
class ReservationCalculator implements ReservationCalculatorInterface
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * Reservation constructor.
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * @inheritDoc
     */
    public function getReservationQuantity($sku, $sourceCode, $allowedOrderStatuses = [])
    {
        $connection = $this->resourceConnection->getConnection();

        $select = $connection
            ->select()
            ->from(['ifos' => 'inventory_fb_orderitem_source'], [ 'qty' => new \Zend_Db_Expr( 'SUM(ifos.qty)')])
            ->joinInner(['so' => 'sales_order'] , 'ifos.order_id = so.entity_id', [])
            ->where('ifos.sku = ?', $sku)
            ->where('ifos.inventory_source_id = ?', $sourceCode);


        if(!empty($allowedOrderStatuses))
        {
            $select->where('so.status IN (?)', $allowedOrderStatuses);
        }

        $reservedQuantity = $connection->fetchOne( $select,[], Zend_Db::FETCH_ASSOC);

        if ($reservedQuantity === null)  {
            return 0.0;
        }

        return (float)$reservedQuantity;
    }
}
