<?php

declare(strict_types=1);

namespace FiloBlu\ExtInventory\Model;

use FiloBlu\ExtInventory\Model\Algorithm\FinalSourceSelectionInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface;
use Magento\Sales\Api\Data\OrderInterface;

/**
 *
 */
class FinalSourceSelectionService implements FinalSourceSelectionServiceInterface
{
    /**
     * @var GetFinalSourceSelectionAlgorithmList
     */
    private $algorithmList;

    /**
     * @param GetFinalSourceSelectionAlgorithmList $algorithmList
     */
    public function __construct(GetFinalSourceSelectionAlgorithmList $algorithmList)
    {
        $this->algorithmList = $algorithmList;
    }

    /**
     * @throws NoSuchEntityException
     */
    public function execute(string $algorithm, OrderInterface $order, SourceSelectionResultInterface $selectionResult): array
    {
        foreach ($this->algorithmList->execute() as $item) {
            if ($item['code'] !== $algorithm) {
                continue;
            }

            /** @var FinalSourceSelectionInterface $instance */
            $instance = $item['handler'];

            return $instance->execute($order, $selectionResult);
        }

        throw new NoSuchEntityException(__("Unable to find final source selection algorithm '%1'", $algorithm));
    }
}
