<?php

namespace FiloBlu\ExtInventory\Model\Data;

use Exception;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Model\ShippingAlgorithms\SourceSlots\SourcesData;
use Magento\Framework\DataObject;
use Magento\Inventory\Model\SourceRepository;

/**
 * Class InventoryFbOrderItemSource
 * @package FiloBlu\ExtInventory\Model\Data
 */
class InventoryFbOrderItemSource extends DataObject implements InventoryFbOrderItemSourceInterface
{
    /**
     * @var SourceRepository
     */
    private $sourceRepository;
    /**
     * @var SourcesData
     */
    private $sourcesData;

    /**
     * InventoryFbOrderItemSource constructor.
     * @param SourceRepository $sourceRepository
     * @param $sourcesData
     * @param array $data
     */
    public function __construct(SourceRepository $sourceRepository, $sourcesData, array $data = [])
    {
        parent::__construct($data);
        $this->sourceRepository = $sourceRepository;
        $this->sourcesData = $sourcesData;
    }

    /**
     * Get inventory_fb_orderitem_source_id
     * @return string|null
     */
    public function getInventoryFbOrderitemSourceId()
    {
        return $this->getData(self::INVENTORY_FB_ORDERITEM_SOURCE_ID);
    }

    /**
     * Set inventory_fb_orderitem_source_id
     * @param string $inventoryFbOrderitemSourceId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setInventoryFbOrderitemSourceId($inventoryFbOrderitemSourceId)
    {
        return $this->setData(self::INVENTORY_FB_ORDERITEM_SOURCE_ID, $inventoryFbOrderitemSourceId);
    }

    /**
     * Get order_id
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->getData(self::ORDER_ID);
    }

    /**
     * Set order_id
     * @param string $orderId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setOrderId($orderId)
    {
        return $this->setData(self::ORDER_ID, $orderId);
    }

    /**
     * Get order_item_id
     * @return string|null
     */
    public function getOrderItemId()
    {
        return $this->getData(self::ORDER_ITEM_ID);
    }

    /**
     * Set order_item_id
     * @param string $orderItemId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setOrderItemId($orderItemId)
    {
        return $this->setData(self::ORDER_ITEM_ID, $orderItemId);
    }

    /**
     * Set inventory_source_id
     * @param string $inventorySourceId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setInventorySourceId($inventorySourceId)
    {
        return $this->setData(self::INVENTORY_SOURCE_ID, $inventorySourceId);
    }

    /**
     * Set final_inventory_source_id
     * @param string $finalInventorySourceId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setFinalInventorySourceId($finalInventorySourceId)
    {
        return $this->setData(self::FINAL_INVENTORY_SOURCE_ID, $finalInventorySourceId);
    }

    /**
     * Get sku
     * @return string|null
     */
    public function getSku()
    {
        return $this->getData(self::SKU);
    }

    /**
     * Set sku
     * @param string $sku
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setSku($sku)
    {
        return $this->setData(self::SKU, $sku);
    }

    /**
     * Get qty
     * @return string|null
     */
    public function getQty()
    {
        return $this->getData(self::QTY);
    }

    /**
     * Set qty
     * @param string $qty
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setQty($qty)
    {
        return $this->setData(self::QTY, $qty);
    }

    /**
     * @inheritDoc
     */
    public function getFinalInventorySource()
    {
        try {
            return $this->sourceRepository->get($this->getFinalInventorySourceId());
        } catch (Exception $e) {
            return null;
        }
    }

    /**
     * Get final_inventory_source_id
     * @return string|null
     */
    public function getFinalInventorySourceId()
    {
        return $this->getData(self::FINAL_INVENTORY_SOURCE_ID);
    }

    /**
     * @inheritDoc
     */
    public function getInventorySource()
    {
        try {
            return $this->sourceRepository->get($this->getInventorySourceId());
        } catch (Exception $e) {
            return null;
        }
    }

    /**
     * Get inventory_source_id
     * @return string|null
     */
    public function getInventorySourceId()
    {
        return $this->getData(self::INVENTORY_SOURCE_ID);
    }

    /**
     * @return string|null
     */
    public function getThirdPartyFinalInventoryCode()
    {
        $order_storeview_id = $this->sourcesData->getOrderStoreviewIdByOrderId($this->getOrderId());
        return $this->sourcesData->getThirdPartyCodeFromSourceCode(
            $this->getFinalInventorySourceId(),$order_storeview_id
        );
    }

    /**
     * @return string|null
     */
    public function getThirdPartyInventoryCode()
    {
        $order_storeview_id = $this->sourcesData->getOrderStoreviewIdByOrderId($this->getOrderId());
        return $this->sourcesData->getThirdPartyCodeFromSourceCode(
            $this->getInventorySourceId(),$order_storeview_id
        );
    }
}
