<?php

declare(strict_types=1);

namespace FiloBlu\ExtInventory\Model\Config\Backend;

use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Api\SearchCriteriaBuilderFactory;
use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Value;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\ValidatorException;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\InventoryApi\Api\SourceRepositoryInterface;
use Magento\InventoryApi\Api\StockRepositoryInterface;
use Magento\InventoryApi\Api\Data\StockSourceLinkInterface;
use Magento\InventoryApi\Api\GetStockSourceLinksInterface;



/**
 * Class Cert
 * @package Magento\Config\Model\Config\Backend\Image
 */
class InventoryType extends Value
{
    /**
     * @var SourceRepositoryInterface
     */
    private $sourceRepository;
    /**
     * @var SearchCriteriaBuilderFactory
     */
    private $searchCriteriaBuilderFactory;
    /**
     * @var StockRepositoryInterface
     */
    private $stockRepository;
    /**
     * @var SearchCriteriaBuilder
     */
    private $apiSearchCriteriaBuilder;
    /**
     * @var GetStockSourceLinksInterface
     */
    private $getStockSourceLinks;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param ScopeConfigInterface $config
     * @param TypeListInterface $cacheTypeList
     * @param SourceRepositoryInterface $sourceRepository
     * @param SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        ScopeConfigInterface $config,
        TypeListInterface $cacheTypeList,
        SourceRepositoryInterface $sourceRepository,
        SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory,
        StockRepositoryInterface $stockRepository,
        SearchCriteriaBuilder $apiSearchCriteriaBuilder,
        GetStockSourceLinksInterface $getStockSourceLinks,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        $this->sourceRepository = $sourceRepository;
        $this->searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
        $this->stockRepository = $stockRepository;
        $this->apiSearchCriteriaBuilder = $apiSearchCriteriaBuilder;
        $this->getStockSourceLinks = $getStockSourceLinks;
        parent::__construct($context, $registry, $config, $cacheTypeList, $resource, $resourceCollection, $data);
    }

    /**
     * @return InventoryType
     * @throws ValidatorException
     */
    public function beforeSave()
    {

        $stockList = $this->stockRepository->getList();
        foreach ($stockList->getItems() as $stock) {
            $searchCriteria = $this->apiSearchCriteriaBuilder
                ->addFilter(StockSourceLinkInterface::STOCK_ID, $stock->getStockId())
                ->create();

            $searchResult = $this->getStockSourceLinks->execute($searchCriteria);

            if ($searchResult->getTotalCount() > 1 && $this->getValue() == 'single_stock') {
                throw new ValidatorException(__('Stock ' . $stock->getStockId() . ' have multiple sources assigned'));
            }
        }

        return parent::beforeSave();
    }
}
