<?php

declare(strict_types=1);

namespace FiloBlu\ExtInventory\Model\Algorithm;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface;
use Magento\Sales\Api\Data\OrderInterface;

/**
 *
 */
class FixedFinalSourceIfMultipleInitialSource implements FinalSourceSelectionInterface
{
    /**
     * @var FixedFinalSource
     */
    private $fixedFinalSource;

    /**
     * @var FinalSourceSelectionInterface
     */
    private $finalSourceSameAsInitialSource;

    /**
     * @param FixedFinalSource $fixedFinalSource
     * @param FinalSourceSelectionInterface $finalSourceSameAsInitialSource
     */
    public function __construct(FinalSourceSelectionInterface $fixedFinalSource,
                                FinalSourceSelectionInterface $finalSourceSameAsInitialSource)
    {
        $this->fixedFinalSource = $fixedFinalSource;
        $this->finalSourceSameAsInitialSource = $finalSourceSameAsInitialSource;
    }

    /**
     * @param OrderInterface $order
     * @param SourceSelectionResultInterface $selectionResult
     * @return array
     * @throws NoSuchEntityException
     */
    public function execute(OrderInterface $order, SourceSelectionResultInterface $selectionResult): array
    {
        $algorithm = $this->finalSourceSameAsInitialSource;

        if ($this->hasMultipleSources($selectionResult)) {
            $algorithm = $this->fixedFinalSource;
        }

        return $algorithm->execute($order, $selectionResult);
    }

    /**
     * @param SourceSelectionResultInterface $selectionResult
     * @return bool
     */
    public function hasMultipleSources(SourceSelectionResultInterface $selectionResult): bool
    {
        $sourceCode = null;
        foreach ($selectionResult->getSourceSelectionItems() as $sourceSelectionItem) {

            if ($sourceCode === null) {
                $sourceCode = $sourceSelectionItem->getSourceCode();
                continue;
            }

            if ($sourceCode !== $sourceSelectionItem->getSourceCode()) {
                return true;
            }
        }

        return false;
    }
}
