<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Data;

use FiloBlu\ExtInventory\Model\GetFinalSourceSelectionAlgorithmList;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class FinalSourceSelectionAlgorithmOptionSource
 * @package FiloBlu\ExtInventory\Data
 */
class FinalSourceSelectionAlgorithmOptionSource implements OptionSourceInterface
{
    /**
     * @var array|null
     */
    protected $options = null;

    /**
     * @var GetFinalSourceSelectionAlgorithmList
     */
    private $algorithmList;

    /**
     * @param GetFinalSourceSelectionAlgorithmList $algorithmList
     */
    public function __construct(GetFinalSourceSelectionAlgorithmList $algorithmList)
    {
        $this->algorithmList = $algorithmList;
    }

    /**
     * @return array|null
     */
    public function toOptionArray()
    {
        if ($this->options !== null) {
            return $this->options;
        }

        foreach ($this->algorithmList->execute() as $algorithm) {

            $this->options[] = [
                'value' => $algorithm['code'],
                'label' => $algorithm['title']
            ];
        }

        return $this->options;
    }
}
