<?php

namespace FiloBlu\ExtInventory\Console\Command;

use FiloBlu\ExtInventory\Model\ReservationCleaner;
use FiloBlu\ExtInventory\Model\ReservationStatus;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class CleanUpReservationsCommand
 * @package FiloBlu\ExtInventory\Console\Command
 */
class CleanUpReservationsCommand extends Command
{
    /**
     * @var ReservationCleaner
     */
    private $reservationCleaner;

    /**
     * CleanUpReservationsCommand constructor.
     * @param ReservationCleaner $reservationCleaner
     * @param string $name
     */
    public function __construct(ReservationCleaner $reservationCleaner, string $name = null)
    {
        parent::__construct($name);
        $this->reservationCleaner = $reservationCleaner;
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|void|null
     * @throws \Exception
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
         $collector = $this->reservationCleaner->cleanAll();

         foreach ($collector->getAll() as $statusCode => $statuses)
         {
             foreach ($statuses as $status){
                 switch ($statusCode) {
                     case ReservationStatus::STATUS_ERROR:
                         $output->writeln("<error>Broken reservations for order with id {$status->getOrderId()}</error>");
                         $this->showInconsistencies($status, $output);
                         break;

                     case ReservationStatus::STATUS_CLEANED:
                         $output->writeln("<info>Cleaned reservations for order with id {$status->getOrderId()}</info>");
                         break;

                     case  ReservationStatus::STATUS_PENDING:
                         $output->writeln("<comment>Order with id {$status->getOrderId()} is not yet completed</comment>");
                         $this->showInconsistencies($status, $output);
                         break;
                 }
             }
         }

    }

    /**
     * @param $result
     * @param $output
     */
    protected function showInconsistencies($result, $output)
    {
        foreach ($result->getInconsistencies() as $sku => $inconsistency) {
            foreach ($inconsistency as $event => $times) {
                $output->writeln("<error> - {$sku} as {$times} extra {$event} event</error>");
            }
        }
    }

    /**
     *
     */
    protected function configure()
    {
        $this->setName('filoblu:reservation:cleanup')
            ->setDescription('Clean up reservations');
    }
}
