<?php

namespace FiloBlu\ExtInventory\Block\Adminhtml\System\Config;

use FiloBlu\ExtInventory\Model\ReservationCalculatorResolver;
use Magento\Framework\Api\SimpleDataObjectConverter;
use Magento\Framework\Option\ArrayInterface;

/**
 * Class ReservationStrategy
 * @package FiloBlu\ExtInventory\Block\Adminhtml\System\Config
 */
class ReservationStrategy implements ArrayInterface
{
    /**
     * @var ReservationCalculatorResolver
     */
    private $reservationCalculatorResolver;

    /**
     * ReservationStrategy constructor.
     * @param ReservationCalculatorResolver $reservationCalculatorResolver
     */
    public function __construct(ReservationCalculatorResolver $reservationCalculatorResolver)
    {
        $this->reservationCalculatorResolver = $reservationCalculatorResolver;
    }

    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        $calculators = $this->reservationCalculatorResolver->getCalculators();
        $options = [];
        foreach ($calculators as $name => $calculator) {

            $options[] = [
                'label' => SimpleDataObjectConverter::snakeCaseToUpperCamelCase($name),
                'value' => $calculator
            ];
        }

        return $options;
    }
}
