<?php

namespace FiloBlu\ExtInventory\Plugin\Model\From;

use FiloBlu\ExtInventory\Model\ReservationCalculatorResolver;
use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 * Class Stock
 * @package FiloBlu\ExtInventory\Plugin\Model\From
 */
class Stock
{
    /**
     * @var ReservationCalculatorResolver
     */
    private $reservationCalculatorResolver;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * Stock constructor.
     * @param ReservationCalculatorResolver $reservationCalculatorResolver
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        ReservationCalculatorResolver $reservationCalculatorResolver,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->reservationCalculatorResolver = $reservationCalculatorResolver;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @param \FiloBlu\Flow\Model\From\Stock $subject
     * @param callable $proceed
     * @param $sku
     * @param $sourceCode
     * @param array $orderStatuses
     * @return int
     */
    public function aroundGetReservedQuantity23(\FiloBlu\Flow\Model\From\Stock $subject, callable $proceed, $sku, $sourceCode, $orderStatuses = []): int
    {
        $enabled = $this->scopeConfig->getValue('msi/general/enable');

        if (!$enabled) {
            return $proceed($sku, $sourceCode, $orderStatuses);
        }

        $calculator = $this->reservationCalculatorResolver->getCalculator();

        if ($calculator === null) {
            return $proceed($sku, $sourceCode, $orderStatuses);
        }

        return $calculator->getReservationQuantity($sku, $sourceCode, $orderStatuses);
    }
}
