<?php
namespace FiloBlu\ExtInventory\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use FiloBlu\ExtInventory\Helper\Data;
use Magento\Framework\App\Config\ScopeConfigInterface;

class CheckProductsBeforePlaceOrder implements ObserverInterface
{

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    const OBSERVER_ENABLE_PATH = 'msi/observer/sales_order_place_before';

    /**
     * @var Data
     */
    private $helper;


    /**
     * CheckProductsBeforePlaceOrder constructor.
     * @param Data $helper
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        Data $helper,
        ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
        $this->helper = $helper;
    }


    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer){
        if(!$this->scopeConfig->getValue(self::OBSERVER_ENABLE_PATH)){
            return;
        }
        /** @var \Magento\Sales\Model\Order $order */
        $order = $observer->getOrder();
        $items = $order->getItems();
        $websiteCode = $order->getStore()->getWebsite()->getCode();
        foreach ($items as $item){
            if($item->getProductType() == "simple"){
                $salableQty = $this->helper->getSalableQty($item,$websiteCode);
                $requestedQty= $item->getQtyOrdered();

                $product = $this->helper->getProductBySku($item->getSku());
                //check if product is in preorder and has backorder active
                if (!$product->getExtensionAttributes()->getStockItem()->getBackorders() && !$product->getIsPreorder()) {
                    if ($requestedQty > $salableQty) {
                        //throw exception
                        throw new \Magento\Framework\Exception\LocalizedException(
                            __('Product with sku ' . $item -> getSku() . ' is not available.')
                        );
                    }
                }
            }
        }
    }


}