<?php

namespace FiloBlu\ExtInventory\Model\Algorithms;

use Magento\InventorySourceSelectionApi\Api\Data\InventoryRequestInterface;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionItemInterfaceFactory;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterfaceFactory;
use Magento\InventorySourceSelectionApi\Model\GetInStockSourceItemsBySkusAndSortedSource;
use Magento\InventorySourceSelectionApi\Model\GetSourceItemQtyAvailableInterface;
use Magento\InventorySourceSelectionApi\Model\SourceSelectionInterface;
use Magento\Sales\Api\Data\OrderInterface;

/**
 * Class AbstractAlgorithm
 * @package FiloBlu\ExtInventory\Model\Algorithms
 */
abstract class AbstractAlgorithm implements SourceSelectionInterface
{
    /**
     * @var SourceSelectionResultInterfaceFactory
     */
    private $sourceSelectionResultFactory;
    /**
     * @var GetSourceItemQtyAvailableInterface
     */
    private $getSourceItemQtyAvailable;
    /**
     * @var GetInStockSourceItemsBySkusAndSortedSource
     */
    private $getInStockSourceItemsBySkusAndSortedSource;
    /**
     * @var SourceSelectionItemInterfaceFactory
     */
    private $sourceSelectionItemFactory;

    /**
     * FinalSourceBasedAlgorithm constructor.
     * @param SourceSelectionResultInterfaceFactory $sourceSelectionResultFactory
     * @param GetSourceItemQtyAvailableInterface $getSourceItemQtyAvailable
     * @param GetInStockSourceItemsBySkusAndSortedSource $getInStockSourceItemsBySkusAndSortedSource
     * @param SourceSelectionItemInterfaceFactory $sourceSelectionItemFactory
     */
    public function __construct(
        SourceSelectionResultInterfaceFactory $sourceSelectionResultFactory,
        GetSourceItemQtyAvailableInterface $getSourceItemQtyAvailable,
        GetInStockSourceItemsBySkusAndSortedSource $getInStockSourceItemsBySkusAndSortedSource,
        SourceSelectionItemInterfaceFactory $sourceSelectionItemFactory
    ) {
        $this->sourceSelectionResultFactory = $sourceSelectionResultFactory;
        $this->getSourceItemQtyAvailable = $getSourceItemQtyAvailable;
        $this->getInStockSourceItemsBySkusAndSortedSource = $getInStockSourceItemsBySkusAndSortedSource;
        $this->sourceSelectionItemFactory = $sourceSelectionItemFactory;
    }

    /**
     * Compare float number with some epsilon
     *
     * @param float $floatNumber
     *
     * @return bool
     */
    public function isZero(float $floatNumber): bool
    {
        return $floatNumber < 0.0000001;
    }

    /**
     * @param InventoryRequestInterface $inventoryRequest
     * @return OrderInterface $order
     */
    protected function getOrder(InventoryRequestInterface $inventoryRequest)
    {
        $extensionAttributes = $inventoryRequest->getExtensionAttributes();
        return $extensionAttributes->getOrder();
    }
}
