<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Model\Algorithm;

use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Helper\Order;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionResultInterface;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Store\Model\ScopeInterface;

/**
 *
 */
class FixedFinalSource implements FinalSourceSelectionInterface
{
    /**
     *
     */
    const XML_PATH_MSI_SOURCES_ALGORITHM_FIXED_SOURCE = 'msi/sources/algorithm_fixed_source';
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @var Order
     */
    private $orderHelper;

    /**
     * @param ScopeConfigInterface $scopeConfig
     * @param Order $orderHelper
     */
    public function __construct(ScopeConfigInterface $scopeConfig,
                                Order                $orderHelper
    )
    {

        $this->scopeConfig = $scopeConfig;
        $this->orderHelper = $orderHelper;
    }

    /**
     * @param OrderInterface $order
     * @param SourceSelectionResultInterface $selectionResult
     * @return InventoryFbOrderItemSourceInterface[]
     * @throws NoSuchEntityException
     */
    public function execute(OrderInterface $order, SourceSelectionResultInterface $selectionResult): array
    {
        $finalSource = $this->scopeConfig->getValue(self::XML_PATH_MSI_SOURCES_ALGORITHM_FIXED_SOURCE,
            ScopeInterface::SCOPE_STORE,
            $order->getStoreId());

        $output = [];
        foreach ($selectionResult->getSourceSelectionItems() as $sourceSelectionItem) {
            $filoBluOrderItem = $this->orderHelper->orderItemToFiloBluOrderItem($order, $sourceSelectionItem);
            $filoBluOrderItem->setFinalInventorySourceId($finalSource);
            $output[] = $filoBluOrderItem;
        }
        return $output;
    }
}
