<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Block\Adminhtml\System\Config;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class InventoryType
 * @package FiloBlu\ExtInventory\Block\Adminhtml\System\Config
 */
class InventoryType implements OptionSourceInterface
{
    const SINGLE_STOCK = 'single_stock';
    const MULTI_STOCK = 'multi_stock';

    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {

        return [
            [
                'label' => 'Single Stock/Single Source',
                'value' => 'single_stock'
            ],
            [
                'label' => 'Multi Stock',
                'value' => 'multi_stock'
            ]
        ];
    }
}
