<?php

namespace FiloBlu\ExtInventory\Api\Data;

use Magento\Framework\Api\ExtensibleDataInterface;

/**
 * Interface InventoryFbOrderItemSourceInterface
 * @package FiloBlu\ExtInventory\Api\Data
 */
interface InventoryFbOrderItemSourceInterface extends ExtensibleDataInterface
{
    /**
     * @var string
     */
    const FINAL_INVENTORY_SOURCE_ID = 'final_inventory_source_id';
    /**
     * @var string
     */
    const INVENTORY_SOURCE_ID = 'inventory_source_id';
    /**
     * @var string
     */
    const QTY = 'qty';
    /**
     * @var string
     */
    const SKU = 'sku';
    /**
     * @var string
     */
    const ORDER_ID = 'order_id';
    /**
     * @var string
     */
    const ORDER_ITEM_ID = 'order_item_id';
    /**
     * @var string
     */
    const INVENTORY_FB_ORDERITEM_SOURCE_ID = 'inventory_fb_orderitem_source_id';

    /**
     * Get inventory_fb_orderitem_source_id
     * @return string|null
     */
    public function getInventoryFbOrderitemSourceId();

    /**
     * Set inventory_fb_orderitem_source_id
     * @param string $inventoryFbOrderitemSourceId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setInventoryFbOrderitemSourceId($inventoryFbOrderitemSourceId);

    /**
     * Get order_id
     * @return string|null
     */
    public function getOrderId();

    /**
     * Set order_id
     * @param string $orderId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setOrderId($orderId);

    /**
     * Get order_item_id
     * @return string|null
     */
    public function getOrderItemId();

    /**
     * Set order_item_id
     * @param string $orderItemId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setOrderItemId($orderItemId);

    /**
     * Get inventory_source_id
     * @return string|null
     */
    public function getInventorySourceId();

    /**
     * Set inventory_source_id
     * @param string $inventorySourceId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setInventorySourceId($inventorySourceId);

    /**
     * Get final_inventory_source_id
     * @return string|null
     */
    public function getFinalInventorySourceId();

    /**
     * Set final_inventory_source_id
     * @param string $finalInventorySourceId
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setFinalInventorySourceId($finalInventorySourceId);

    /**
     * Get sku
     * @return string|null
     */
    public function getSku();

    /**
     * Set sku
     * @param string $sku
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setSku($sku);

    /**
     * Get qty
     * @return string|null
     */
    public function getQty();

    /**
     * Set qty
     * @param string $qty
     * @return InventoryFbOrderItemSourceInterface
     */
    public function setQty($qty);

    /**
     * @return \Magento\InventoryApi\Api\Data\SourceInterface|null
     */
    public function getFinalInventorySource();

    /**
     * @return \Magento\InventoryApi\Api\Data\SourceInterface|null
     */
    public function getInventorySource();

    /**
     * @return string|null
     */
    public function getThirdPartyFinalInventoryCode();

    /**
     * @return string|null
     */
    public function getThirdPartyInventoryCode();

}
