<?php

namespace FiloBlu\ExtInventory\Plugin\Api\OrderItemRepositoryInterface;

use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Api\InventoryFbOrderItemSourceRepositoryInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Sales\Api\Data\OrderItemInterface;
use Magento\Sales\Api\OrderItemRepositoryInterface;

/**
 * Class OrderItemRepositoryInterface
 * @package FiloBlu\ExtInventory\Plugin\Api
 */
class AfterSave
{

    /**
     * @var InventoryFbOrderItemSourceRepositoryInterface
     */
    private $inventoryFbOrderItemSourceRepository;

    /**
     * OrderItemRepositoryInterface constructor.
     * @param InventoryFbOrderItemSourceRepositoryInterface $inventoryFbOrderItemSourceRepository
     */
    public function __construct(
        InventoryFbOrderItemSourceRepositoryInterface $inventoryFbOrderItemSourceRepository
    )
    {
        $this->inventoryFbOrderItemSourceRepository = $inventoryFbOrderItemSourceRepository;
    }

    /**
     * @param OrderItemRepositoryInterface $subject
     * @param OrderItemInterface $entity
     * @return OrderItemInterface
     * @throws LocalizedException
     */
    public function afterSave(
        OrderItemRepositoryInterface $subject,
        OrderItemInterface           $entity
    )
    {
        $extensionAttributes = $entity->getExtensionAttributes();

        if ($extensionAttributes === null) {
            return $entity;
        }

        $filoBluOrderItems = $extensionAttributes->getFilobluOrderItem();

        if ($filoBluOrderItems === null || empty($filoBluOrderItems)) {
            return $entity;
        }
        /** @var InventoryFbOrderItemSourceInterface $filoBluOrderItem */
        foreach ($filoBluOrderItems as $filoBluOrderItem) {
            $this->inventoryFbOrderItemSourceRepository->save($filoBluOrderItem);
        }

        return $entity;
    }
}
