<?php

namespace FiloBlu\ExtInventory\Plugin\Api\OrderItemRepositoryInterface;

use Exception;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterfaceFactory;
use FiloBlu\ExtInventory\Api\InventoryFbOrderItemSourceRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Sales\Api\Data\OrderItemExtensionInterfaceFactory;
use Magento\Sales\Api\Data\OrderItemSearchResultInterface;
use Magento\Sales\Api\OrderItemRepositoryInterface;

/**
 * Class AfterGetList
 * @package FiloBlu\ExtInventory\Plugin\Api\OrderItemRepositoryInterface
 */
class AfterGetList
{

    /**
     * @var InventoryFbOrderItemSourceRepositoryInterface
     */
    private $inventoryFbOrderItemSourceRepository;

    /**
     * @var OrderItemExtensionInterfaceFactory
     */
    private $orderItemExtensionInterfaceFactory;
    /**
     * @var InventoryFbOrderItemSourceInterfaceFactory
     */
    private $fbOrderItemSourceInterfaceFactory;
    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;


    /**
     * OrderItemRepositoryInterface constructor.
     * @param InventoryFbOrderItemSourceRepositoryInterface $inventoryFbOrderItemSourceRepository
     * @param OrderItemExtensionInterfaceFactory $orderItemExtensionInterfaceFactory
     * @param InventoryFbOrderItemSourceInterfaceFactory $fbOrderItemSourceInterfaceFactory
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     */
    public function __construct(
        InventoryFbOrderItemSourceRepositoryInterface $inventoryFbOrderItemSourceRepository,
        OrderItemExtensionInterfaceFactory            $orderItemExtensionInterfaceFactory,
        InventoryFbOrderItemSourceInterfaceFactory    $fbOrderItemSourceInterfaceFactory,
        SearchCriteriaBuilder                         $searchCriteriaBuilder
    ) {
        $this->inventoryFbOrderItemSourceRepository = $inventoryFbOrderItemSourceRepository;
        $this->orderItemExtensionInterfaceFactory = $orderItemExtensionInterfaceFactory;
        $this->fbOrderItemSourceInterfaceFactory = $fbOrderItemSourceInterfaceFactory;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * @param OrderItemRepositoryInterface $subject
     * @param OrderItemSearchResultInterface $searchCriteria
     * @return OrderItemSearchResultInterface
     */
    public function afterGetList(OrderItemRepositoryInterface $subject, OrderItemSearchResultInterface $searchCriteria)
    {
        foreach ($searchCriteria->getItems() as $entity) {
            $extensionAttributes = $entity->getExtensionAttributes();
            if ($extensionAttributes === null) {
                $extensionAttributes = $this->orderItemExtensionInterfaceFactory->create();
            }

            try {
                $this->searchCriteriaBuilder->addFilter('order_item_id', $entity->getItemId());
                $filoBluOrderItem = $this->inventoryFbOrderItemSourceRepository->getList(
                    $this->searchCriteriaBuilder->addFilter('order_item_id', $entity->getItemId())->create()
                );
                $extensionAttributes->setFilobluOrderItem($filoBluOrderItem->getItems());
            } catch (Exception $exception) {
                $extensionAttributes->setFilobluOrderItem($this->fbOrderItemSourceInterfaceFactory->create());
            }
            $entity->setExtensionAttributes($extensionAttributes);
        }
        return $searchCriteria;
    }
}
