<?php
namespace FiloBlu\ExtInventory\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use FiloBlu\ExtInventory\Helper\Data;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Store\Model\StoreManagerInterface;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable;

class ProductSalableQtyCheck implements ObserverInterface
{

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;


    const OBSERVER_ENABLE_PATH = 'msi/observer/checkout_cart_product_add_before';

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var Configurable
     */
    private $configurable;
    /**
     * @var Data
     */
    private $helper;


    /**
     * ProductSalableQtyCheck constructor.
     * @param Data $helper
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreManagerInterface $storeManager
     * @param Configurable $configurable
     */
    public function __construct(
        Data $helper,
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager,
        Configurable  $configurable)
    {
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->configurable = $configurable;
        $this->helper = $helper;
    }


    /**
     * @param Observer $observer
     * @throws LocalizedException
     */
    public function execute(Observer $observer){
        if(!$this->scopeConfig->getValue(self::OBSERVER_ENABLE_PATH)){
            return;
        }
        $parentProduct = $observer->getProduct();
        $productType = $parentProduct->getTypeId();
        if($productType == 'simple'){
            $product = $parentProduct;
        }else{
            $requestedProduct = $observer->getInfo()['super_attribute'];
            $product  = $this->configurable->getProductByAttributes($requestedProduct,$parentProduct);
        }
        $websiteCode = $this->storeManager->getWebsite()->getCode();
        $salableQty = $this->helper->getSalableQty($product,$websiteCode);
        $requestedQty = $observer->getInfo()['qty'];

        // Check if product is in preorder and has backorder active
        // TODO: getIsPreorder() only exists on santoni ????
        if (!$product->getExtensionAttributes()->getStockItem()->getBackorders() && !$product->getIsPreorder()) {
            if($requestedQty > $salableQty){
                //throw exception
                throw new LocalizedException(
                    __('Product that you are trying to add is not available.')
                );
            }
        }
    }
}
