<?php

namespace FiloBlu\ExtInventory\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\ObjectManagerInterface;

/**
 * Class ReservationDeductionResolver
 * @package FiloBlu\ExtInventory\Model
 */
class ReservationCalculatorResolver
{
    /**
     * @var array
     */
    private $reservationCalculators;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * ReservationDeductionResolver constructor.
     * @param ScopeConfigInterface $scopeConfig
     * @param ObjectManagerInterface $objectManager
     * @param array $reservationCalculators
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        ObjectManagerInterface $objectManager,
        $reservationCalculators = []
    ) {
        $this->reservationCalculators = $reservationCalculators;
        $this->scopeConfig = $scopeConfig;
        $this->objectManager = $objectManager;
    }

    /**
     * @return ReservationCalculatorInterface|null
     */
    public function getCalculator()
    {
        $configuredCalculator = $this->scopeConfig->getValue('msi/general/reservation_calculator');

        if (!$configuredCalculator) {
            return null;
        }

        foreach ($this->reservationCalculators as $name => $calculator) {
            if ($configuredCalculator === $name) {
                return $this->objectManager->create($calculator);
            }

            if ($calculator === $configuredCalculator) {
                return $this->objectManager->create($calculator);
            }
        }

        return null;
    }

    /**
     * @return array
     */
    public function getCalculators(): array
    {
        return $this->reservationCalculators;
    }
}
