<?php

namespace FiloBlu\ExtInventory\Model;

use Magento\Framework\App\ResourceConnection;
use Zend_Db;

/**
 * Class OutdatedStockItemCleaner
 * @package FiloBlu\ExtInventory\Model
 */
class OutdatedStockItemCleaner
{

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    public function __construct(
        ResourceConnection $resourceConnection
    ) {
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * Clean inventory source item for no longer existing products
     * @return array list of deleted source item skus
     */
    public function clean()
    {
        $connection = $this->resourceConnection->getConnection();
        $itemTable = $this->resourceConnection->getTableName('inventory_source_item');
        $productTable = $this->resourceConnection->getTableName('catalog_product_entity');

        $toDelete = $connection
            ->fetchAll(
                "SELECT `sku` FROM `{$itemTable}` WHERE `sku` NOT IN ( SELECT `sku` FROM `{$productTable}`)",
                Zend_Db::FETCH_ASSOC
            );

        $skuToDelete = [];
        foreach ($toDelete as $item) {
            $skuToDelete[] = $item['sku'];
        }

        $connection->delete('inventory_source_item', ['sku IN (?)' => $skuToDelete]);

        return $skuToDelete;
    }
}
