<?php

namespace FiloBlu\ExtInventory\Model;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Inventory\Model\ResourceModel\StockSourceLink\Collection;
use Magento\InventoryReservationsApi\Model\ReservationInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Zend_Db;

/**
 * Class DefaultReservationCalculator
 * @package FiloBlu\ExtInventory\Model
 */
class DefaultReservationCalculator implements ReservationCalculatorInterface
{
    /**
     * @var SerializerInterface
     */
    private $serializer;
    /**
     * @var Collection
     */
    private $collection;
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;

    /**
     * DefaultReservationCalculator constructor.
     * @param SerializerInterface $serializer
     * @param Collection $collection
     * @param OrderRepositoryInterface $orderRepository
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(
        SerializerInterface $serializer,
                                Collection $collection,
                                OrderRepositoryInterface $orderRepository,
                                ResourceConnection $resourceConnection
    ) {
        $this->serializer = $serializer;
        $this->collection = $collection;
        $this->resourceConnection = $resourceConnection;
        $this->orderRepository = $orderRepository;
    }

    /**
     * @inheritDoc
     */
    public function getReservationQuantity($sku, $sourceCode, $allowedOrderStatuses = [])
    {
        $reservationQuantity = 0;
        $stockLink = $this->collection->addFieldToFilter('source_code', ['eq' => $sourceCode])->getFirstItem();

        $connection = $this->resourceConnection->getConnection();
        $reservationTable = $connection->getTableName('inventory_reservation');

        $select = $connection->select()
            ->from($reservationTable)
            ->where(ReservationInterface::SKU . ' = ?', $sku)
            ->where(ReservationInterface::STOCK_ID . ' = ?', $stockLink->getStockId());

        $reservations = $connection->fetchAll($select, [], Zend_Db::FETCH_ASSOC);

        foreach ($reservations as $reservation) {
            $metadata = $this->serializer->unserialize($reservation[ReservationInterface::METADATA]);
            $objectType = $metadata['object_type'];
            $event = $metadata['event_type'];
            $orderId = $metadata['object_id'];

            if ($objectType !== 'order') {
                continue;
            }

            if ($event !== 'order_placed') {
                continue;
            }

            $order = $this->orderRepository->get($orderId);

            if (!in_array($order->getStatus(), $allowedOrderStatuses, true)) {
                continue;
            }

            $reservationQuantity -= (int)$reservation[ReservationInterface::QUANTITY];
        }

        return $reservationQuantity;
    }
}
