<?php
namespace FiloBlu\ExtInventory\Block\Adminhtml\System\Config;

use \FiloBlu\ExtInventory\Model\ShippingAlgorithms\SourceSlots\SourcesData;

class Sources implements \Magento\Framework\Option\ArrayInterface
{

    protected $sourcesCollection;
    protected $sourcesData;

    public function __construct(
        \Magento\Inventory\Model\ResourceModel\Source\Collection $getSourcesCollection,
        SourcesData $sourcesData
    ) {
        $this->sourcesCollection = $getSourcesCollection;
        $this->sourcesData = $sourcesData;
    }


    /**
     * @param bool $skip_main
     * @return array
     */
    public function toOptionArray($skip_main = false)
    {
        $sourceListArr = $this->sourcesCollection->load();
        $sourceList = array(['label' => '--Please Select--', 'value' => '']);

        $main_source_code = $this->sourcesData->getMainSourceCode();

        foreach ($sourceListArr as $source) {

            if($source->getSourceCode() == 'default'){
                // With multi inventory we handle only additional sources
                // Ignoring the Magento 'default' source and leaving that to zero quantity
                // This way we can handle all the stock the same way
                continue;
            }

            if ($skip_main && $source->getSourceCode() == $main_source_code){
                continue;
            }

            $tmp = array();
            $tmp['value'] = $source->getSourceCode();
            $tmp['label'] = $source->getName();
            $sourceList[] = $tmp;
        }

        return $sourceList;
    }
}