<?php

namespace FiloBlu\ExtInventory\Block\Adminhtml\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\View\Element\Html\Select;

/**
 *
 */
class Msiextraconfig extends AbstractFieldArray
{
    protected $sourcesCollection;

    public function __construct(
        Sources $getSourcesCollection,
        Context $context,
        array   $data = []
    )
    {
        $this->sourcesCollection = $getSourcesCollection;
        parent::__construct($context, $data);
    }

    protected function _prepareToRender()
    {
        $eventTypeBlock = $this->getLayout()->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'source'))
            ->setName($this->_getCellInputElementName('source'))
            ->setClass('select')
            ->setOptions($this->sourcesCollection->toOptionArray());

        $this->addColumn('source', [
            'label'    => __('Source'),
            'renderer' => $eventTypeBlock
        ]);

        $this->addColumn('daily_max_slots', [
            'label' => __('Daily Maximum Slots')
        ]);

        $this->addColumn('third_parties_code', [
            'label' => __('Third Parties Code')
        ]);

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add new configuration');
    }

}
