<?php

namespace FiloBlu\ExtInventory\Api;

use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceSearchResultsInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Sales\Api\Data\OrderItemInterface;

/**
 * Interface InventoryFbOrderItemSourceRepositoryInterface
 * @package FiloBlu\ExtInventory\Api
 */
interface InventoryFbOrderItemSourceRepositoryInterface
{

    /**
     * Save inventory_fb_orderitem_source
     * @param InventoryFbOrderItemSourceInterface $inventoryFbOrderItemSource
     * @return InventoryFbOrderItemSourceInterface
     * @throws LocalizedException
     */
    public function save(InventoryFbOrderItemSourceInterface $inventoryFbOrderItemSource);

    /**
     * Retrieve inventory_fb_orderitem_source
     * @param string $inventoryFbOrderItemSourceId
     * @return InventoryFbOrderItemSourceInterface
     * @throws LocalizedException
     */
    public function get($inventoryFbOrderItemSourceId);

    /**
     * @param OrderItemInterface $orderItem
     * @return InventoryFbOrderItemSourceInterface
     */
    public function getByOrderItem(OrderItemInterface $orderItem);
    /**
     * Retrieve inventory_fb_orderitem_source matching the specified criteria.
     * @param SearchCriteriaInterface $searchCriteria
     * @return InventoryFbOrderItemSourceSearchResultsInterface
     * @throws LocalizedException
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete inventory_fb_orderitem_source
     * @param InventoryFbOrderItemSourceInterface $inventoryFbOrderItemSource
     * @return bool true on success
     * @throws LocalizedException
     */
    public function delete(InventoryFbOrderItemSourceInterface $inventoryFbOrderItemSource);

    /**
     * Delete inventory_fb_orderitem_source by ID
     * @param string $inventoryFbOrderItemSourceId
     * @return bool true on success
     * @throws NoSuchEntityException
     * @throws LocalizedException
     */
    public function deleteById($inventoryFbOrderItemSourceId);
}
