<?php
declare(strict_types=1);

use Magento\Framework\App\Bootstrap;
use Magento\InventoryApi\Api\Data\SourceItemInterface;

require __DIR__ . '/../../../../../app/bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$objectManager = $bootstrap->getObjectManager();


/** @var \FiloBlu\ExtInventory\Helper\Data $helperData */
$helperData = $objectManager->get(\FiloBlu\ExtInventory\Helper\Data::class);


$reservedQuantity = $helperData->getSalableQuantityBySourceItem(
    $objectManager->create(SourceItemInterface::class, [
        'data' => [
            'source_code' => 'santoni_usa',
            'sku'         => 'MBWI21303BARRDSPN5008',
            'status'      => 1,
            'quantity'    => 8
        ]])
);

echo "Done\n";

