<?php
declare(strict_types=1);

use FiloBlu\ExtInventory\Helper\Order;
use FiloBlu\ExtInventory\Plugin\Magento\Sales\Api\OrderManagementInterface;
use Magento\Framework\App\Bootstrap;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionItemInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

require __DIR__ . '/../../../../../app/bootstrap.php';
$params = $_SERVER;
$bootstrap = Bootstrap::create(BP, $params);
$objectManager = $bootstrap->getObjectManager();

/** @var  \Magento\Sales\Api\OrderManagementInterface $orderManagement */
$orderManagement = $objectManager->get(\Magento\Sales\Api\OrderManagementInterface::class);

/** @var  OrderRepositoryInterface $orderRepository */
$orderRepository = $objectManager->get(OrderRepositoryInterface::class);

/** @var OrderManagementInterface $plugin */
$plugin = $objectManager->get(OrderManagementInterface::class);
/** @var \FiloBlu\ExtInventory\Helper\Data $helperData */
$helperData = $objectManager->get(\FiloBlu\ExtInventory\Helper\Data::class);

$order = $orderRepository->get('22984');

/** @var Order $helper */
$helper = $objectManager->get(Order::class);



$orderFiloBlu = $helper->orderItemToFiloBluOrderItem($order, $objectManager->create(SourceSelectionItemInterface::class, [
    'sourceCode' => 'santono',
    'sku' => 'MBCC21540BARNHODU6009',
    'qtyToDeduct' => '1',
    'qtyAvailable' => 6
]));

$plugin->afterPlace($orderManagement,[], $order);
