<?php

namespace FiloBlu\ExtInventory\Plugin\Api\OrderRepositoryInterface;

use FiloBlu\ExtInventory\Helper\Data;
use Magento\Sales\Api\Data\OrderExtensionFactory;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

/**
 * Class AfterGet
 * @package FiloBlu\ExtInventory\Plugin\Api\OrderRepositoryInterface
 */
class AfterGet
{
    /**
     * @var OrderExtensionFactory
     */
    protected $orderExtensionFactory;

    /**
     * @var Data
     */
    private $helperData;

    /**
     * AfterGet constructor.
     * @param OrderExtensionFactory $orderExtensionFactory
     * @param Data $helperData
     */
    public function __construct(
        OrderExtensionFactory $orderExtensionFactory,
        Data                  $helperData
    )
    {
        $this->orderExtensionFactory = $orderExtensionFactory;
        $this->helperData = $helperData;
    }

    /**
     * Add Data to order
     *
     * @param OrderRepositoryInterface $subject
     * @param OrderInterface $resultOrder
     * @return OrderInterface
     */
    public function afterGet(
        OrderRepositoryInterface $subject,
        OrderInterface           $resultOrder
    )
    {
        $extensionAttributes = $resultOrder->getExtensionAttributes();

        if (!$extensionAttributes) {
            $extensionAttributes = $this->orderExtensionFactory->create();
            $resultOrder->setExtensionAttributes($extensionAttributes);
        }

        $stockType = $this->helperData->getInventoryType($resultOrder->getStoreId());
        $extensionAttributes->setFilobluInventoryType($stockType);

        return $this->helperData->getFiloBluOrderItems($resultOrder);
    }

}
