<?php

namespace FiloBlu\ExtInventory\Model\ResourceModel;

use FiloBlu\ExtInventory\Model\ReservationCleaner;
use FiloBlu\ExtInventory\Model\ReservationStatus;
use Magento\InventoryReservationsApi\Model\CleanupReservationsInterface;
use Psr\Log\LoggerInterface;

/**
 * Class CleanupReservations
 * @package FiloBlu\ExtInventory\Model\ResourceModel
 */
class CleanupReservations implements CleanupReservationsInterface
{
    /**
     * @var ReservationCleaner
     */
    private $reservationCleaner;
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * CleanUpReservationsCommand constructor.
     * @param LoggerInterface $logger
     * @param ReservationCleaner $reservationCleaner
     */
    public function __construct(LoggerInterface $logger, ReservationCleaner $reservationCleaner)
    {
        $this->reservationCleaner = $reservationCleaner;
        $this->logger = $logger;
    }

    /**
     * @inheritDoc
     */
    public function execute(): void
    {
        $orderIds = $this->reservationCleaner->getOrderIds();

        foreach ($orderIds as $orderId) {
            $result = $this->reservationCleaner->clean($orderId);
            if ($result->getStatus() === ReservationStatus::STATUS_ERROR) {
                $this->logger->error("Broken reservations for order with id {$orderId}");
            }
        }
    }
}
