<?php

namespace FiloBlu\ExtInventory\Model;

/**
 * Class ReservationStatusCollector
 * @package FiloBlu\ExtInventory\Model
 */
class ReservationStatusCollector
{
    /**
     * @var array
     */
    protected $statuses = [];

    /**
     *
     */
    public function reset()
    {
        $this->statuses = [];
    }

    /**
     * @return array
     */
    public function getAll()
    {
        return $this->statuses;
    }

    /**
     * @param ReservationStatus $status
     */
    public function add(ReservationStatus $status)
    {
        $this->statuses[$status->getStatus()][] = $status;
    }

    /**
     * @param int $status
     * @return ReservationStatus[]
     */
    public function getByStatus(int $status)
    {
        if (isset($this->statuses[$status])) {
            return $this->statuses[$status];
        }

        return [];
    }

    /**
     * @param int $status
     * @return bool
     */
    public function hasStatus(int $status)
    {
        return isset($this->statuses[$status]) && count($this->statuses) > 0;
    }
}
