<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Model;

use FiloBlu\ExtInventory\Helper\Data;
use Magento\InventoryApi\Api\Data\SourceItemInterface;
use Magento\InventorySourceSelectionApi\Model\GetSourceItemQtyAvailableInterface;

/**
 *
 */
class GetSourceItemQtyAvailableService implements GetSourceItemQtyAvailableInterface
{
    /**
     * @var Data
     */
    private $helperData;

    /**
     * @param Data $helperData
     */
    public function __construct(Data $helperData)
    {
        $this->helperData = $helperData;
    }

    /**
     * @inheritDoc
     */
    public function execute(SourceItemInterface $sourceItem): float
    {
        return $this->helperData->getSalableQuantityBySourceItem($sourceItem);
    }
}
