<?php
declare(strict_types=1);

namespace FiloBlu\ExtInventory\Helper;

use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterface;
use FiloBlu\ExtInventory\Api\Data\InventoryFbOrderItemSourceInterfaceFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\InventorySourceSelectionApi\Api\Data\SourceSelectionItemInterface;
use Magento\Sales\Api\Data\OrderInterface;

/**
 *
 */
class Order
{
    /**
     * @var InventoryFbOrderItemSourceInterfaceFactory
     */
    private $fbOrderItemSourceFactory;

    /**
     * @param InventoryFbOrderItemSourceInterfaceFactory $fbOrderItemSourceFactory
     */
    public function __construct(InventoryFbOrderItemSourceInterfaceFactory $fbOrderItemSourceFactory)
    {

        $this->fbOrderItemSourceFactory = $fbOrderItemSourceFactory;
    }

    /**
     * @param OrderInterface $order
     * @param SourceSelectionItemInterface $sourceSelectionItem
     * @return InventoryFbOrderItemSourceInterface
     * @throws NoSuchEntityException
     */
    public function orderItemToFiloBluOrderItem(OrderInterface $order, SourceSelectionItemInterface $sourceSelectionItem): InventoryFbOrderItemSourceInterface
    {

        $orderItem = $this->findOrderItemBySku($order, $sourceSelectionItem->getSku());

        return $this->fbOrderItemSourceFactory->create(
            [
                'data' => [
                    InventoryFbOrderItemSourceInterface::FINAL_INVENTORY_SOURCE_ID => $sourceSelectionItem->getSourceCode(),
                    InventoryFbOrderItemSourceInterface::INVENTORY_SOURCE_ID       => $sourceSelectionItem->getSourceCode(),
                    InventoryFbOrderItemSourceInterface::QTY                       => $sourceSelectionItem->getQtyToDeduct(),
                    InventoryFbOrderItemSourceInterface::SKU                       => $sourceSelectionItem->getSku(),
                    InventoryFbOrderItemSourceInterface::ORDER_ID                  => $order->getEntityId(),
                    InventoryFbOrderItemSourceInterface::ORDER_ITEM_ID             => $orderItem->getId()
                ]
            ]);
    }

    /**
     * @param OrderInterface | Order $order
     * @param $simpleSku
     * @return bool|mixed
     * @throws NoSuchEntityException
     */
    public function findOrderItemBySku($order, $simpleSku)
    {
        $items = $order->getAllItems();
        foreach ($items as $item) {
            if ($item->getProductType() == 'simple' && $item->getSku() === $simpleSku) {
                return $item;
            }
        }

        throw new NoSuchEntityException(__('Unable to find order item with sku = %1', $simpleSku));
    }
}
