<?php

namespace FiloBlu\Esb\Ui\Component\Queue\Listing;

use FiloBlu\Esb\Api\QueueItemRepositoryInterface;
use FiloBlu\Esb\Ui\Component\AbstractDataProvider;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\App\RequestInterface;

/**
 * Class DataProvider
 * @package FiloBlu\Esb\Ui\Component\Queue\Listing
 */
class DataProvider extends AbstractDataProvider
{

    /**
     * @var QueueItemRepositoryInterface
     */
    protected $itemRepository;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param QueueItemRepositoryInterface $itemRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param FilterBuilder $filterBuilder
     * @param RequestInterface $request
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        QueueItemRepositoryInterface $itemRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder,
        RequestInterface $request,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $searchCriteriaBuilder, $filterBuilder, $request, $meta, $data);
        $this->itemRepository = $itemRepository;
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        $searchCriteria = $this->getSearchCriteria();
        $result = $this->itemRepository->getList($this->getSearchCriteria(), true);
        return [
            'items' => $result->getItems(),
            'totalRecords' => $this->itemRepository->count($searchCriteria, true)
        ];
    }

    /**
     * @inheritDoc
     */
    public function getSearchResult()
    {
        $searchCriteria = $this->getSearchCriteria();
        return $this->itemRepository->getList($searchCriteria);
    }
}
