<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Observer;

use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Framework\Event\EventEmitter;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Api\Data\OrderInterface;

/**
 * Observer on invoice register
 */
class SalesOrderInvoiceRegister implements ObserverInterface
{
    /**
     * @var EventEmitter
     */
    private $eventEmitter;
    /**
     * @var EventInterface
     */
    private $eventToEmit;

    /**
     * OrderSaveAfter constructor.
     * @param EventEmitter $eventEmitter
     * @param EventInterface $eventToEmit
     */
    public function __construct(EventEmitter $eventEmitter, EventInterface $eventToEmit)
    {
        $this->eventEmitter = $eventEmitter;
        $this->eventToEmit = $eventToEmit;
    }

    /**
     * @param Observer $observer
     * @return void
     * @throws \Exception
     */
    public function execute(Observer $observer)
    {
        /** @var OrderInterface $order */
        $order = $observer->getEvent()->getOrder();
        $this->eventEmitter->emit($this->eventToEmit, $order);
    }
}
