<?php

namespace FiloBlu\Esb\Model\Saver;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\ObjectTypeSaverInterface;
use FiloBlu\Esb\Framework\ObjectType\Endpoint\AbstractEndpoint;
use Magento\Sales\Api\ShipmentRepositoryInterface;
use RuntimeException;

/**
 * Class ShipmentSaver
 * @package FiloBlu\Esb\Model\Saver
 */
class ShipmentSaver extends AbstractEndpoint implements ObjectTypeSaverInterface
{

    /**
     * @var ShipmentRepositoryInterface
     */
    private $shipmentRepository;

    /**
     * OrderLoader constructor.
     * @param ShipmentRepositoryInterface $shipmentRepository
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     */
    public function __construct(ShipmentRepositoryInterface $shipmentRepository, ObjectTypeDescriptorInterface $objectTypeDescriptor)
    {
        parent::__construct($objectTypeDescriptor);
        $this->shipmentRepository = $shipmentRepository;
    }


    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return 'Esb shipment saver';
    }

    /**
     * @inheritDoc
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::shipment_saver';
    }

    /**
     * @inheritDoc
     */
    public function save(ObjectTypeDescriptorInterface $objectType, $objectToSave)
    {
        if (!$this->isSuitableFor($objectType)) {
            throw new RuntimeException("Incompatible loader for type {$objectType->getTypeCode()}");
        }

        $this->shipmentRepository->save($objectToSave);
    }
}
