<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\PublisherResolverInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\ObjectManagerInterface;

/**
 * Class PublisherResolver
 * @package FiloBlu\Esb\Model
 */
class PublisherResolver implements PublisherResolverInterface
{

    /**
     * @var array
     */
    private $publisher;
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * PublisherResolver constructor.
     * @param ObjectManagerInterface $objectManager
     * @param array $publishers
     */
    public function __construct(
        ObjectManagerInterface $objectManager,
        $publishers
    ) {
        $this->publisher = $publishers;
        $this->objectManager = $objectManager;
    }

    /**
     * @inheritDoc
     */
    public function get($publisherCode)
    {
        if (!array_key_exists($publisherCode, $this->publisher)) {
            throw new NoSuchEntityException(__("Could not find publisher with code '%s'", $publisherCode));
        }

        return $this->objectManager->create($this->publisher[$publisherCode]);
    }

    /**
     * @inheritDoc
     */
    public function getDefault()
    {
        if (empty($this->publisher)) {
            throw new NoSuchEntityException(__('No publisher defined'));
        }
        return $this->objectManager->create(reset($this->publisher));
    }

    /**
     * @inheritDoc
     */
    public function getAll()
    {
        return $this->publisher;
    }
}
