<?php

namespace FiloBlu\Esb\Model\ObjectType;

use FiloBlu\Esb\Api\ObjectTypeDescriptorResolverInterface;
use Magento\Framework\Api\SimpleDataObjectConverter;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Options
 * @package FiloBlu\Esb\Model\ObjectType
 */
class Options implements OptionSourceInterface
{
    /**
     * @var array
     */
    protected $options = [];

    /**
     * @var ObjectTypeDescriptorResolverInterface
     */
    private $objectTypeDescriptorResolver;

    /**
     * Options constructor.
     * @param ObjectTypeDescriptorResolverInterface $objectTypeDescriptorResolver
     */
    public function __construct(ObjectTypeDescriptorResolverInterface $objectTypeDescriptorResolver)
    {
        $this->objectTypeDescriptorResolver = $objectTypeDescriptorResolver;
    }

    /**
     * @return array|null
     */
    public function toOptionArray()
    {
        if (!empty($this->options)) {
            return $this->options;
        }

        $result = $this->objectTypeDescriptorResolver->getAll();

        foreach ($result as $name => $item) {
            $this->options[] = [
                'value' => get_class($item),
                'label' => SimpleDataObjectConverter::snakeCaseToUpperCamelCase($name)
            ];
        }

        return $this->options;
    }
}
