<?php

namespace FiloBlu\Esb\Model\Loader;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\Data\ObjectTypeInterface;
use FiloBlu\Esb\Api\ObjectTypeLoaderInterface;
use FiloBlu\Esb\Framework\ObjectType\Endpoint\AbstractEndpoint;
use Magento\Customer\Api\AddressRepositoryInterface;
use RuntimeException;

/**
 * Class CustomerAddressLoader
 * @package FiloBlu\Esb\Model\Loader
 */
class CustomerAddressLoader extends AbstractEndpoint implements ObjectTypeLoaderInterface
{
    /**
     * @var AddressRepositoryInterface
     */
    private $customerAddressRepository;

    /**
     * CustomerAddressLoader constructor.
     * @param AddressRepositoryInterface $customerAddressRepository
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     */
    public function __construct(AddressRepositoryInterface $customerAddressRepository, ObjectTypeDescriptorInterface $objectTypeDescriptor)
    {
        parent::__construct($objectTypeDescriptor);
        $this->customerAddressRepository = $customerAddressRepository;
    }

    /**
     * @inheritDoc
     */
    public function get(ObjectTypeInterface $objectType)
    {
        if (!$this->isSuitableFor($objectType)) {
            throw new RuntimeException("Incompatible loader for type {$objectType->getTypeCode()}");
        }

        return $this->customerAddressRepository->getById($objectType->getId());
    }

    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return 'Esb customer address loader';
    }

    /**
     * @inheritDoc
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::customer_address_loader';
    }
}

