<?php
/**
 * Copyright © 2017 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Helper;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;

/**
 * Class LoggerProvider
 * @package FiloBlu\Esb\Helper
 */
class LoggerProvider
{

    /**
     * @var Logger
     */
    protected $_logger;

    /**
     * LoggerProvider constructor.
     * @param Filesystem $filesystem
     * @param string $filename
     * @throws \Exception
     */
    public function __construct(
        Filesystem $filesystem,
        $filename = 'filoblu_esb'
    ) {
        $channelName = 'esb';
        $this->_logger = new Logger($channelName);

        $vardir = $filesystem
            ->getDirectoryRead(DirectoryList::VAR_DIR)
            ->getAbsolutePath();

        $this->_logger->pushHandler(new StreamHandler(
            $vardir . 'log' . DIRECTORY_SEPARATOR . basename($filename) . '.log'
        ));
    }

    public function getLogger()
    {
        return $this->_logger;
    }
}
