<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Helper\Format;

/**
 * Interface for ESB format helpers (JSON, XML, ...)
 */
interface FormatInterface
{
    /**
     * Formats data array
     *
     * @param array $data
     * @return string
     */
    public function format($data);

    /**
     * Get HTTP Content Type (application/xml, application/json, ...)
     * @return string
     */
    public function getContentType();
}
