<?php

namespace FiloBlu\Esb\Framework\Data;

use Exception;
use FiloBlu\Esb\Api\ConsumerConfigurationRepositoryInterface;
use FiloBlu\Esb\Api\ConsumerResolverInterface;
use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\ProducerConfigurationRepositoryInterface;
use FiloBlu\Esb\Api\ProducerResolverInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class AbstractFilterableByEndpointOptions
 * @package FiloBlu\Esb\Framework\Data
 */
abstract class AbstractFilterableByEndpointOptions implements OptionSourceInterface
{

    /** @var array */
    protected $options = [];

    /** @var RequestInterface */
    private $request;

    /** @var ProducerConfigurationRepositoryInterface */
    private $producerConfigurationRepository;

    /** @var ConsumerConfigurationRepositoryInterface */
    private $consumerConfigurationRepository;

    /**
     * @var ProducerResolverInterface
     */
    private $producerResolver;
    /**
     * @var ConsumerResolverInterface
     */
    private $consumerResolver;

    /**
     * Options constructor.
     * @param RequestInterface $request
     * @param ProducerConfigurationRepositoryInterface $producerConfigurationRepository
     * @param ConsumerConfigurationRepositoryInterface $consumerConfigurationRepository
     * @param ProducerResolverInterface $producerResolver
     * @param ConsumerResolverInterface $consumerResolver
     */
    public function __construct(
        RequestInterface $request,
        ProducerConfigurationRepositoryInterface $producerConfigurationRepository,
        ConsumerConfigurationRepositoryInterface $consumerConfigurationRepository,
        ProducerResolverInterface $producerResolver,
        ConsumerResolverInterface $consumerResolver
    ) {
        $this->request = $request;
        $this->producerConfigurationRepository = $producerConfigurationRepository;
        $this->consumerConfigurationRepository = $consumerConfigurationRepository;
        $this->producerResolver = $producerResolver;
        $this->consumerResolver = $consumerResolver;
    }

    /**
     * @return ObjectTypeDescriptorInterface|null
     */
    protected function getObjectTypeDescriptor()
    {
        $id = $this->request->getParam('id', null);
        $type = $this->request->getParam('type', null);

        if ($id === null && $type === null) {
            return null;
        }

        $endpoint = null;
        try {
            switch ($this->request->getControllerName()) {
                case 'consumer':
                    if ($id) {
                        return $this->consumerConfigurationRepository->getById($id)->getConsumer()->getObjectTypeDescriptor();
                    }
                    if ($type) {
                        return $this->consumerResolver->get($type)->getObjectTypeDescriptor();
                    }

                    break;

                case 'producer':
                    $producer = $this->producerConfigurationRepository->getById($id);
                    return $this->producerResolver->get($producer->getProducer())->getObjectTypeDescriptor();
                    break;
                default:
                    return null;
            }
        } catch (Exception $exception) {
            return null;
        }
    }
}
