<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class InOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class InOperator implements OperatorInterface
{

    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'in';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand)  : bool
    {
        return in_array($leftOperand, is_array($rightOperand) ? $rightOperand : [$rightOperand], false);
    }
}
