<?php

declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class EndsWithOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class EndsWithOperator implements OperatorInterface
{

    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'endswith';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool
    {
        $length = strlen($rightOperand);
        if ($length == 0) {
            return true;
        }
        return (substr($leftOperand, -$length) === $rightOperand);
    }
}
