<?php

namespace FiloBlu\Esb\Controller\Adminhtml\Common;

use Magento\Backend\App\Action;
use Magento\Framework\Controller\Result\Redirect;

/**
 * Class AbstractEdit
 * @package FiloBlu\Esb\Controller\Adminhtml\Common
 */
abstract class AbstractEdit extends Action
{

    /**
     * @inheritDoc
     */
    abstract public function execute();

    /**
     * @param string|int|null $id
     * @return Redirect
     */
    protected function getRedirectPath($id = null): Redirect
    {
        $backTo = $this->getRequest()->getParam('back', false);

        if ($id === null || $backTo === false) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        return $this->resultRedirectFactory->create()->setPath("*/*/{$backTo}", ['id' => $id]);
    }
}
