<?php

namespace FiloBlu\Esb\Block\Adminhtml\Consumer\Edit;

use FiloBlu\Esb\Block\Adminhtml\Common\Button;

/**
 * Class BackButton
 */
class BackButton extends Button
{
    /**
     * @inheritDoc
     */
    public function getButtonData()
    {
        return [
            'label' => __('Back'),
            'on_click' => sprintf("location.href = '%s';", $this->getUrl('*/*/', [])),
            'class' => 'back',
            'sort_order' => 10
        ];
    }
}
